﻿
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.Linq;
using System.Xml.Linq;

namespace WindowsApplication1
{
	public partial class Form1
	{

		internal Form1()
		{
			InitializeComponent();
		}
		private const short VendorID = 6017; // Definimos el VendorID.
		private const short ProductID = 2000; // Definimos el ProductID.

		// Declaramos los buffer's de entrada y salida de datos.
		private const short BufferInSize = 8; // Definimos el tamaño del buffer entrada.
		private const short BufferOutSize = 8; // Definimos el tamaño del buffer de salida.
		private byte[] BufferIn = new byte[BufferInSize + 1];
		private byte[] BufferOut = new byte[BufferOutSize + 1];

		private void Form1_Load(object sender, System.EventArgs e)
		{
			HIDDLLInterface.ConnectToHID(ref this); // Al ejecutarse el formulario conectamos el dispositivo al controlador.
		}

		private void Form1_FormClosed(object sender, System.Windows.Forms.FormClosedEventArgs e)
		{
			HIDDLLInterface.DisconnectFromHID(); // Si cerramos el formulario desconectamos el dispositivo del controlador.
		}

		// Si se conecta el dispositivo al host...
		public void OnPlugged(int pHandle)
		{
			if (HIDDLLInterface.hidGetVendorID(pHandle) == VendorID && HIDDLLInterface.hidGetProductID(pHandle) == ProductID)
			{
				this.estado.BackColor = Color.Green;
				this.estado_conexion.Text = "CONECTADO";
			}
		}

		// Si se desconecta el dispositivo del host...
		public void OnUnplugged(int pHandle)
		{
			if (HIDDLLInterface.hidGetVendorID(pHandle) == VendorID && HIDDLLInterface.hidGetProductID(pHandle) == ProductID)
			{
				HIDDLLInterface.hidSetReadNotify(HIDDLLInterface.hidGetHandle(VendorID, ProductID), false);
				this.estado.BackColor = Color.Red;
				this.estado_conexion.Text = "DESCONECTADO";
			}
		}

		public void OnChanged() // LLama a todas las funciones de mensajes.
		{
			int pHandle = 0;
			pHandle = HIDDLLInterface.hidGetHandle(VendorID, ProductID);
			HIDDLLInterface.hidSetReadNotify(HIDDLLInterface.hidGetHandle(VendorID, ProductID), true);
		}

		// Si recibimos un dato...
		public void OnRead(int pHandle)
		{
//INSTANT C# TODO TASK: In VB, the following line changed the value of the array element BufferIn(0) as a side effect. It will need to be recoded since C# does not allow passing array elements as 'ref' arguments.
			if (HIDDLLInterface.hidRead(pHandle, ref BufferIn[0]))
			{
				// Aqui se reciben los datos a partir del BufferIn(1) = dato del micro..
			}
		}

		public void WriteSomeData() // Si hay un dato listo para enviar...
		{
			byte tempVar = BufferOut[0];
			HIDDLLInterface.hidWriteEx(VendorID, ProductID, ref tempVar);
				BufferOut[0] = tempVar;
		}

		private void boton_Click(object sender, System.EventArgs e)
		{
			BufferOut[1] = 1;
			WriteSomeData();
		}
	}

}